#include "header/interface.h"
void initInputForRouter(NetDB &netdb);
void userDefinedParameter(ParamSet &par);

int main( int argc, char *argv[] ) {//ispd

	// This part can be removed
	printf("\n===========================================================\n");
	printf("License Agreement for NCTU-GR 2.0\n");
	printf("Copyright (c) 2013 by Wen-Hao Liu and Yih-Lang Li\n");
	printf("http://cs.nctu.edu.tw/~whliu/NCTU-GR.htm\n");
	printf("All right reserved\n");
	printf("Lasted updated: 2013/11/01\n");
	printf("===========================================================\n\n");

	//initialization
	NetDB netdb ;
	initInputForRouter(netdb);
	ParamSet par;
	setDefaultParameter(par, false);
	userDefinedParameter(par);
	settingAndChecking(netdb, par, true);
	GlobalRouter gr(netdb.gridX, netdb.gridY, netdb.layer, netdb.horCap, netdb.verCap);

	//Perform Routing
	main_congestion_estimator( netdb, par, gr, NULL) ;

	//Extract Routing Infomation
	printf("totalWL=%d totalOverflow=%d totalVia=%d totalRuntime=%.2lf\n", gr.totalWL, gr.tof, gr.totalVia, gr.totalRuntime);
	int congestion=getGapOfDemAndCap(gr, 3, 3, true);
	int netOverflow=getOverflowOfNet(gr, netdb.netArray[0]);
	vector<int> netIdArray = getPassingNet(gr, netdb.netArray, 3, 3, true);
	int netWL=getWLofNet(netdb.netArray[0]);
	printf("congestion=%d netOverflow=%d netIDSize=%d netWL=%d\n", congestion, netOverflow, netIdArray.size(), netWL);

	//Clear routing result
	clearRoutingResult(netdb);

	return 0 ;
}

void initInputForRouter(NetDB &netdb)
{
	//Initialize grid graph's dimensions and default capacity
	netdb.gridX = 500;
	netdb.gridY = 500;
	netdb.layer = 9;
	netdb.horCap.resize(netdb.layer);
	netdb.verCap.resize(netdb.layer);
	for(int i=0; i<netdb.layer; i++)
	{
		if(i&1==1) //odd layer
		{
			netdb.horCap[i] = 0;
			netdb.verCap[i] = 10;
		}
		else
		{
			netdb.verCap[i] = 0;
			netdb.horCap[i] = 10;
		}
	}

	//specialize capacity
	AdjustCapEdge edge;
	edge.x=0;
	edge.y=0;
	edge.z=0;
	edge.hori=true;
	edge.value=0;
	netdb.adjArray.push_back(edge);

	//randomly set terminals for 10000 nets
	int numNet=10000;
	netdb.netArray.clear();
	netdb.netArray.resize(numNet);
	for(int i=0; i<numNet; i++)
	{
		Net &n= netdb.netArray[i];
		n.id=i;
		int numPin=10;
		Point pp;
		for(int j=0; j<numPin; j++)
		{
			pp.x=rand()%netdb.gridX;
			pp.y=rand()%netdb.gridY;
			pp.z=rand()%netdb.layer;
			n.pin3D.push_back(pp);
		}
	}	
}


void userDefinedParameter(ParamSet &par)
{
	par.PtRounds=1;
	par.MnRounds=1;
	par.RarRounds=3;
	par.laType=0;
	par.print_to_screen=true;
}
